% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme.r
\name{scglrTheme}
\alias{scglrTheme}
\title{Function that fits the theme model}
\usage{
scglrTheme(formula, data, H, family, size = NULL, weights = NULL,
  offset = NULL, subset = NULL, na.action = na.omit, crit = list(),
  method = methodSR(), st = FALSE)
}
\arguments{
\item{formula}{an object of class "\code{\link[=multivariateFormula]{MultivariateFormula}}" (or one that can be coerced
to that class): a symbolic description of the model to be fitted. The details
of model specification are given under Details.}

\item{data}{data frame.}

\item{H}{vector of R integer. Number of components to keep for each theme}

\item{family}{a vector of character of the same length as the number of dependent variables:
"bernoulli", "binomial", "poisson" or "gaussian" is allowed.}

\item{size}{describes the number of trials for the binomial dependent variables.
A (number of statistical units * number of binomial dependent variables) matrix is expected.}

\item{weights}{weights on individuals (not available for now)}

\item{offset}{used for the poisson dependent variables.
A vector or a matrix of size: number of observations * number of Poisson dependent variables is expected.}

\item{subset}{an optional vector specifying a subset of observations to be used in the fitting process.}

\item{na.action}{a function which indicates what should happen when the data contain NAs. The default is set to \code{na.omit}.}

\item{crit}{a list of two elements : maxit and tol, describing respectively the maximum number of iterations and
the tolerance convergence criterion for the Fisher scoring algorithm. Default is set to 50 and 10e-6 respectively.}

\item{method}{structural relevance criterion. Object of class "method.SCGLR"
built by  \code{\link{methodSR}} for Structural Relevance.}

\item{st}{logical (FALSE) theme build and fit order. TRUE means random, FALSE means sequential (T1, ..., Tr)}
}
\value{
a list of SCGLRTHM class. Each element is a SCGLR object
}
\description{
Calculates the components to predict all the dependent variables.
}
\details{
Models for theme are specified symbolically. A model as the form \code{response ~ terms} where \code{response}
is the numeric response vector and terms is a series of R themes composed of
predictors. Themes are separated by  "|" (pipe) and are composed. ... Y1+Y2+...
~ X11+X12+...+X1_  | X21+X22+... | ...+X1_+...  | A1+A2+... See \code{\link{multivariateFormula}}.
}
\examples{
\dontrun{
library(SCGLR)

# load sample data
data(genus)

# get variable names from dataset
n <- names(genus)
n <-n[!n\%in\%c("geology","surface","lon","lat","forest","altitude")]
ny <- n[grep("^gen",n)]    # Y <- names that begins with "gen"
nx1 <- n[grep("^evi",n)]   # X <- remaining names
nx2 <- n[-c(grep("^evi",n),grep("^gen",n))]


form <- multivariateFormula(ny,nx1,nx2,A=c("geology"))
fam <- rep("poisson",length(ny))
testthm <-scglrTheme(form,data=genus,H=c(2,2),family=fam,offset = genus$surface)
plot(testthm)
}
}
