% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/semUtils.R
\name{graph2dagitty}
\alias{graph2dagitty}
\title{Graph conversion from igraph to dagitty}
\usage{
graph2dagitty(graph, canonical = FALSE, verbose = FALSE, ...)
}
\arguments{
\item{graph}{A graph as an igraph or dagitty object.}

\item{canonical}{A logical value. If TRUE, DAG conversion is enforced
(for \code{graph2dagitty} only). This argument is FALSE by default.}

\item{verbose}{A logical value. If TRUE, the output graph is shown
(for \code{graph2dagitty} only). This argument is FALSE by default.}

\item{...}{Currently ignored.}
}
\value{
A dagitty object.
}
\description{
Convert an igraph object to a dagitty object.
}
\examples{

# Graph as an igraph object to dagitty object
G <- graph2dagitty(sachs$graph)
plot(dagitty::graphLayout(G))

}
\author{
Mario Grassi \email{mario.grassi@unipv.it}
}
