% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/path_to_network.R
\name{path_to_network}
\alias{path_to_network}
\title{Precision matrix from ordered path model}
\usage{
path_to_network(B, psi = NULL, output = "precision")
}
\arguments{
\item{B}{input \eqn{p \times p} weights matrix}

\item{psi}{variance-covariance matrix for the residuals. If NULL (the default) will impose
the constraint that the variables have variance 1 and the residuals are uncorrelated}

\item{output}{Function returns the precision ("precision") or covariance ("covariance") matrix}
}
\value{
a \eqn{p \times p} precision or covariance matrix
}
\description{
Takes a path model and generates the corresponding (standardized) precision matrix or
covariance matrix. The inverse of \code{\link{network_to_path}}.
}
\references{
\insertRef{ryan2019}{SEset}

    \insertRef{shojaie2010penalized}{SEset}

    \insertRef{bollen89sem}{SEset}
}
\seealso{
\code{\link{network_to_path}}, \code{\link{SEset_to_network}}
}
