% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smartest.R
\name{smartest}
\alias{smartest}
\title{Conduct statistical tests using a SMART data}
\usage{
smartest(
  data,
  family = c("gaussian", "binomial")[1],
  method = c("Gest", "IPW")[1],
  digits = NULL,
  common = FALSE,
  alpha = 0.05,
  adjust = NULL,
  ntest = NULL
)
}
\arguments{
\item{data}{Input data frame of the SMART data
used for analysis, which include the variables of
 stage-1 treatments (A1), intermediate outcome (O2),
 stage-2 treatment (A2) and final primary outcome (Y).
  If stage-1 treatment takes into account baseline
  information, baseline information (O1) also needs
  to be included.}

\item{family}{A character string to specify
the type of final primary outcome. The default
is family=“gaussian”, which refers to the continuous
 primary outcome. If family=”binomial” then the primary
  outcome will be treated as binary variable.}

\item{method}{Method used to estimate the value of
adaptive treatment strategy. "Gest" for G-computation
 method and "IPW" for Inversed Probabiliy Weight
 method. Default is method="Gest".}

\item{digits}{An integer indicating the number of
decimal places for sequence-specific mean and
 variance. Default is digits=NULL.}

\item{common}{If common=TRUE, the pooled variance
across all the treatment sequences are used in
 estimation. Otherwise use the sequence-specific
  variance. The default is common=FALSE.}

\item{alpha}{Significant level of confidence
interval. The default is alpha=0.05.}

\item{adjust}{A characteristic string to
indicate whether the confidence intervals pairwise
 distance adjusted for multiple comparison. The default
 is adjust=NULL, which indicated no adjustment for
 multiple comparison. If adjust=”Bon”, the CIs are
  adjusted for the Bonferroni correction.}

\item{ntest}{Number of pairwise tests adjusted for
Bonferroni correction}
}
\value{
An objects of “Strategy” is return, which
lists all the adaptive treatment strategy defined
 in the input data with an index number.
\itemize{
   \item ATS: Index of the treatment adaptive
    treatment strategy defined in the input dataset
   \item ds: the sequence of decision makings
    that define an adaptive treatment strategy
   \item N: number of subjects following an
   adaptive treatment strategy in the intut dataset
   }
An objects of "Global.test" is return,
which give the result of the global test.
\itemize{
   \item size: the total number of subjects
   in the input dataset
   \item nATS: the total number of adaptive
    treatment strategies defined in the input dataset
   \item df: the degrees of freedom of the
    global test, which is a chisquare test
   \item chisq: the chisquare test statistics for the global test
   \item Pvalue: the P-value of the global test
   }
An object of "Pairwise.test"
\itemize{
   \item label: The labels of pairwise tests.
    The details of strategies are shown in $Strategy
   \item diff: Estimated pairwise distance between
    treatment and control adaptive treatment strategy
   \item lower.CI: Lower bound of confidence interval
    for pairwise distance
   \item upper.CI: Upper bound of confidence interval
    for pairwise distance
   \item Z: Test statistics of pairwise test
   \item P-value: P-value of pairwise test
   }
}
\description{
Return a message that contains the results of
 statistical tests to compare the values of adaptive treatment
  strategies defined in a SMART data. The statistical tests
  include (1) a global test (2) a series of pairwise tests.
}
\examples{

smartest(data=codiacs,family="gaussian",method="Gest",
common=FALSE,alpha=0.05,adjust="Bon")

}
\references{
Murphy, S. A. (2005),``An experimental
design for the development of adaptive treatment
strategies'' \emph{Statistics in Medicine}, 24, 1455-1481.

Ogbagaber S. B., Karp, J., and
Wahed A.S. (2015), ``Design of sequentially randomization
 trials for testing adaptive treatment
 strategies,'' \emph{Statistics in Medicine},
 DOI: 10.1002/sim.6747.
}
