% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OSOAs_hadamard.R
\name{OSOAs_hadamard}
\alias{OSOAs_hadamard}
\title{function to create a strength 3 OSOA with 8-level columns from a Hadamard matrix}
\usage{
OSOAs_hadamard(
  m = NULL,
  n = NULL,
  el = 3,
  noptim.rounds = 1,
  noptim.repeats = 1,
  optimize = TRUE,
  dmethod = "manhattan",
  p = 50
)
}
\arguments{
\item{m}{the number of columns to be created;
if \code{n} is also given, \code{m} must be compatible with it; at present, \code{m} can be at most 98.}

\item{n}{the number of runs to be created; \code{n} must be a multiple of 8 and can (at present) be at most 200;
if \code{m} is also given, \code{n} must be compatible with it.}

\item{el}{exponent for 2, can be 2 or 3: the OSOA will have columns with
2^el (4 or 8) levels}

\item{noptim.rounds}{the number of optimization rounds for each independent restart}

\item{noptim.repeats}{the number of independent restarts of optimizations with \code{noptim.rounds} rounds each}

\item{optimize}{logical: should space filling be optimized by level permutations?}

\item{dmethod}{distance method for \code{\link{phi_p}}, "manhattan" (default) or "euclidean"}

\item{p}{p for \code{\link{phi_p}} (the larger, the closer to maximin distance)}
}
\value{
matrix of class \code{SOA} with the attributes that are listed below. All attributes can be accessed using function \code{\link{attributes}}, or individual attributes can be accessed using function \code{\link{attr}}. These are the attributes:
\describe{
\item{type}{the type of array (\code{SOA} or \code{OSOA})}
\item{strength}{character string that gives the strength}
\item{phi_p}{the phi_p value (smaller=better)}
\item{optimized}{logical indicating whether optimization was applied}
\item{permpick}{matrix that lists the id numbers of the permutations used}
\item{perms2pickfrom}{optional element, when optimization was conducted: the
overall permutation list to which the numbers in permlist refer}
\item{call}{the call that created the object}
}
}
\description{
A Hadamard matrix in k runs is used for creating an OSOA in n=2k runs for at most m=k-2 columns.
}
\details{
At least one of \code{m} or \code{n} must be provided. For \code{el=2},
Zhou and Tang (2019) strength 3- designs are created, for \code{el=3} strength
3 designs by Li, Liu and Yang (2021).\cr
Li et al.'s creation of the matrix A has been enhanced by using a column specific
fold-over, which is beneficial for the space-filling properties (see Groemping 2021).
}
\examples{
dim(OSOAs_hadamard(9, optimize=FALSE))  ## 9 8-level factors in 24 runs
dim(OSOAs_hadamard(n=16, optimize=FALSE)) ## 6 8-level factors in 16 runs
OSOAs_hadamard(n=24, m=6, optimize=FALSE) ## 6 8-level factors in 24 runs
                                          ## (though 10 would be possible)
dim(OSOAs_hadamard(m=35, optimize=FALSE)) ## 35 8-level factors in 80 runs
}
\references{
For full detail, see \code{\link{SOAs-package}}.

Groemping (2021)\cr
Li, Liu and Yang (2021)\cr
Weng (2014)\cr
Zhou and Tang (2019)
}
\author{
Ulrike Groemping
}
