% Generated by roxygen2 (4.0.2): do not edit by hand
\name{sQDA}
\alias{sQDA}
\title{Spase Quadratic Discriminant Analysis}
\usage{
sQDA(train.data = NULL, test.data = NULL, len = 100, lams = seq(0.02, 1,
  length = 10), presel = T, prelam = 0.2, margin = 0.05)
}
\arguments{
\item{train.data}{data matrix with column names being the class labels and row names being the genes.}

\item{test.data}{the new data needs to be predicted.}

\item{len}{block size}

\item{lams}{a sequence of \code{lambda}'s from cross-validation.}

\item{presel}{pre-selection indicator.}

\item{prelam}{pre-selection sparisty parameter, only used when presel=T.}

\item{margin}{error margin for pre-selection, only used when presel=T.}
}
\value{
returns a list object with following items.
\item{pred}{predictions for class labels on the test.data}
\item{p}{the number of blocks selected}
}
\description{
Spase Quadratic Discriminant Analysis
}
\examples{
data(exampledata)
res<-sQDA(train.data[1:100,],test.data[1:100,],lams=0.2,presel=FALSE)
sum(res$pred!=colnames(test.data))/ncol(test.data)  ##prediction error
res$p ## number of blocks selected
res$pred ## predicted class labels on test.data
}
\references{
The application of sparse estimation of covariance matrix to quadratic discriminant analysis. Jiehuan Sun and Hongyu Zhao.
}

