% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{Gradient_COMP_cpp}
\alias{Gradient_COMP_cpp}
\title{COMP Gradient}
\usage{
Gradient_COMP_cpp(d, W, residue)
}
\arguments{
\item{d}{is a dictionary element}

\item{W}{is a frequency matrix \eqn{m \times s} with frequency vectors in matrix rows.}

\item{residue}{is a residue vector.}
}
\value{
a gradient vector
}
\description{
The gradient of the objective function from the Compressive Orthogonal Matching Pursuit
with respect to a dictionary element.
}
\details{
\code{Gradient_COMP_cpp} computes the gradient of the objective function
\eqn{OF(d) = -\frac{SK(d)\cdot r}{\|SK(d)\|}}, where \eqn{SK(d)} denotes a
sketch of the dictionary element \code{d} and \eqn{r} is the residue vector.
The gradient is given as \eqn{\nabla_d OF(d) = \frac{-G(SK(d), y, W)}{\|SK(d)\|}}, where
a vector \eqn{y  = r-\left(r^{\top} \cdot SK(d)\right)\cdot SK(d)} and
a function \eqn{G(x, y, W)} is
given as:
\eqn{G(x,y, W) = \left(x[1:m]\odot y[m+1:2m] - x[m+1]\odot y[1:m]\right)^{\top}\cdot W},
where \eqn{\odot} denotes an element-wise vector multiplication.
}
\examples{
X = matrix(abs(rnorm(n = 1000)), ncol = 100, nrow = 10)
X_fbm = bigstatsr::as_FBM(X)$save()
W = chickn::GenerateFrequencies(Data = X_fbm, m = 64, N0 = ncol(X_fbm),
                                ncores = 1, niter= 3, nblocks = 2, sigma_start = 0.001)$W
SK= chickn::Sketch(X_fbm, W)
D = X_fbm[, sample(ncol(X_fbm), 10)]
weights = sample(10, 10)/10
SK_D = rbind(cos(W\%*\%D), sin(W\%*\%D))
d = D[,1]
r = SK - SK_D\%*\%weights
Grad = Gradient_COMP_cpp(d, W, r)
}
\seealso{
\code{\link{ObjFun_COMP_cpp}}, \code{\link{COMP_initialization}}
}
