% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ShiftConvolve.R
\name{ShiftConvolvePoibin}
\alias{ShiftConvolvePoibin}
\alias{dpoisbin}
\alias{ppoisbin}
\alias{qpoisbin}
\alias{rpoisbin}
\title{ShiftConvolve Poisson Binomial}
\usage{
dpoisbin(x, probs, method = "ShiftConvolve", log.p = FALSE)

ppoisbin(x, probs, method = "ShiftConvolve", lower.tail = TRUE, log.p = FALSE)

qpoisbin(p, probs, method = "ShiftConvolve", lower.tail = TRUE, log.p = FALSE)

rpoisbin(n, probs)
}
\arguments{
\item{x}{Either a vector of observed numbers of successes
(or vector of quantiles as dbinom/pbinom refers to) or NULL.
If NULL, probabilities of all possible observations are returned.}

\item{probs}{Vector of probabilities of success of each Bernoulli
trial.}

\item{method}{Character string that specifies the method of computation
and must be either \code{"ShiftConvolve"} or \code{"DC"}}

\item{log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{Logical value indicating if results are \eqn{P[X \le x]}
(if \code{TRUE}; default) or \eqn{P[X > x]} (if
\code{FALSE}).}

\item{p}{Vector of probabilities for computation of quantiles.}

\item{n}{Number of observations. If \code{length(n) > 1}, the
length is taken to be the number required.}
}
\value{
\code{dpoisbin} gives the density, \code{ppoisbin} computes the distribution
function, \code{qpoisbin} gives the quantile function and \code{rpoisbin}
generates random deviates.
}
\description{
Density, distribution function, quantile function and random generation for
the Poisson binomial distribution with the option of using the ShiftConvolvePoibin method.
}
\details{
Computing the Poisson Binomial Distribution using ShiftConvolve

A package which uses exponential shifting and Fast Fourier Transformations with the minFFT library to
compute the distribution of the Poisson Binomial Distribution
}
\section{References}{

Peres, N., Lee, A., and Keich, U. (2020). Exactly computing the tail of the Poisson-Binomial Distribution.
   \href{https://arxiv.org/abs/2004.07429}{
   arXiv:2004.07429}
}

\examples{
set.seed(18)
n=1000
probs <- runif(n)
x <- c(200, 500, 800)
p <- seq(0, 1, 0.01)
dpoisbin(x,probs,method="ShiftConvolve",log.p=FALSE)
ppoisbin(x,probs,method="ShiftConvolve",lower.tail=FALSE,log.p=TRUE)
qpoisbin(p,probs,method="ShiftConvolve",lower.tail=TRUE,log.p=FALSE)
rpoisbin(n,probs)
}
\author{
Andrew Ray Lee, Noah Peres and Uri Keich
}
