% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute.B.from.beta.R
\name{compute.B.from.beta}
\alias{compute.B.from.beta}
\title{Global co-regulation coefficient computation}
\usage{
compute.B.from.beta(beta_fun)
}
\arguments{
\item{beta_fun}{Matrix of co-regulation coefficients}
}
\value{
Numeric vector of the \code{n} global co-regulation coefficients.

If \code{beta_fun} is \code{NULL}, \code{compute.B.from.beta} returns \code{NULL}.
}
\description{
Computes the global co-regulation coefficients \code{B} from a matrix of co-regulation coefficients \code{beta}
}
\details{
\code{beta_fun} have same number of rows and columns.
}
\examples{
beta <- matrix(c(1,10,5,0.1,1,0.5,0.2,2,1),nrow=3)
correl <- "RegPos"

is.beta.accurate(beta,3,correl)

B <- compute.B.from.beta(beta)


}
\seealso{
Use function \code{\link{is.beta.accurate}} to verify \code{beta_fun} conformity.
}
