% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mut.kin.R
\name{mut.kin}
\alias{mut.kin}
\title{Mutation of kinetic parameters}
\usage{
mut.kin(kin_fun,i_fun,nu_fun,typ_A=1)
}
\arguments{
\item{kin_fun}{Numeric vector of enzyme kinetic parameter, which are the resident values}

\item{i_fun}{Numeric value indicating the number of the enzyme targeted by the mutation}

\item{nu_fun}{Numeric value of mutation size}

\item{typ_A}{Numeric for mutation method. Default is 1. \emph{See details in \code{\link{mut.kin}}.}}
}
\value{
Numeric vector of mutant values of enzyme kinetic parameters
}
\description{
Computes the mutant value of enzyme kinetic parameters
}
\details{
This function used three mutation methods:
\itemize{
   \item Additive method (\code{typ_A=1}): mutant kinetic parameter is the sum of the resident one plus size of mutation \eqn{\nu}
   \item Multiplicative method (\code{typ_A=2}): mutant kinetic parameter is the product of the resident one and \eqn{1+\nu}
   \item Random method (\code{typ_A=3}): mutant kinetic parameter is equal to the mutation size
   }
   
 The method 1 is the default one.
}
\examples{
kin <- c(1,10,1000)
mu <- 1 #size of mutation
i <- 3 #enzyme directly targeted by mutation

mut.kin(kin,i,mu)

}
\seealso{
See function \code{\link{mut.E.direct}} to compute mutation for enzyme concentrations.

See function \code{\link{activities}} to compute "activities" from enzyme kinetic parameters.
}
