% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LifeSim_Functions.R
\name{get_onsetHazard}
\alias{get_onsetHazard}
\title{Calculate the onset hazard for an individual}
\usage{
get_onsetHazard(sub_hazard, sub_GRR, carrier_prob, RV_status)
}
\arguments{
\item{sub_hazard}{The hazard rate of disease for the subtype of interest}

\item{sub_GRR}{The genetic relative risk of disease for the subtype of interest.}

\item{carrier_prob}{Numeric.  The carrier probability for all causal variants with relative-risk of disease \code{GRR}.  By default, \code{carrier_prob}\code{ = 0.002}}

\item{RV_status}{Numeric. \code{RV_status = TRUE} if the individual is a carrier of a rare variant that increases disease suseptibility, and \code{FALSE} otherwise.}
}
\value{
The baseline age-specific hazard rates of disease
}
\description{
Calculate the onset hazard rate of disease for an individual given the carrier probability and the genetic relative risk for the subtype and the individual's RV status.
}
\keyword{internal}
