% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sites.R
\name{Sites}
\alias{Sites}
\title{Finds the number of sites of interest from already calculated residence times}
\usage{
Sites(Name, R, first = 'n', number_sites = -1)
}
\arguments{
\item{Name}{name of the data, which is used for any saved files and plot titles}

\item{R}{radius value to use}

\item{first}{if \code{'y'}, the algorithm will look for the second greatest maximum percent drop if the first results in the first circle being the only non-identified site}

\item{number_sites}{number of sites to manually show the results for}
}
\value{
sites_index - array of indices of the sites of interest among all the circles

N_no_overlap - number of non-overlapping circles

X_no_overlap - x-coordinates of non-overlapping circles

Y_no_overlap - y-coordinates of non-overlapping circles

X_sites - x-coordinates of identified sites of interest

Y_sites - y-coordinates of identified sites of interest

max_percent_drop - maximum percent drop

number_identified_sites - number of identified sites

psi_sort_no_overlap2 - ordered list of non-overlapping residence times
}
\description{
Finds the number of sites of interest as well as other information from already calculated residence times.
}
\details{
This function finds all the necessary information from the results of the already applied algorithm \code{\link{Alt_Alg}}. It returns information relating to both the non-overlapping circles and also the identified sites, which is then used by other functions. The information is extracted from the already saved csv files.
}
\examples{
\donttest{##Find the current working directory
wd = getwd()
##Set the working directory as the temporary one
setwd(tempdir())
##Set the working directory as the temporary one
setwd(tempdir())
##Load the data
data(OU_14)
t=unlist(OU_14["t"])
X=unlist(OU_14["X"])
Y=unlist(OU_14["Y"])

##Calculate the residence time with a radius of 0.3 and not including the first circle
Alt_Alg("OU_14",t,X,Y,0.3,first='y',save='y')

##Calculate all the necessary information to be used elsewhere
Sites("OU_14",0.3,first='y')

##Reset the original working directory
setwd(wd)}
}
\references{
Munden, R., Borger , L., Wilson, R.P., Redcliffe, J., Loison, A., Garel, M. and Potts, J.P. in review. Making sense of ultra-high-resolution movement data: an algorithm for inferring sites of interest.
}
\seealso{
See also \code{\link{Alt_Alg}} to find the residence times.
}
\author{
Rhys Munden <rdmunden1@sheffield.ac.uk>
}
