% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ffphase.R
\name{ffphase}
\alias{ffphase}
\title{Fast flight phase of the cube method}
\usage{
ffphase(X, pik)
}
\arguments{
\item{X}{A matrix of size (\eqn{N} x \eqn{p}) of auxiliary variables on which the sample must be balanced.}

\item{pik}{A vector of inclusion probabilities.}
}
\value{
Updated vector of \code{pik} that contains 0 and 1 for unit that are rejected or selected.
}
\description{
This function computes the flight phase of the cube method proposed by Chauvet and Tillé (2006).
}
\details{
This function implements the method proposed by (Chauvet and Tillé 2006). It recursively transforms the vector of inclusion probabilities \code{pik} into a
sample that respects the balancing equations. The algorithm stops when the null space of the sub-matrix \eqn{B} is empty.
For more information see (Chauvet and Tillé 2006).

The function uses the function \code{\link[MASS:Null]{Null}} to find the null space of the sub-matrix \eqn{B}.
}
\examples{

N <- 100
n <- 10
p <- 4

pik <- rep(n/N,N)
X <- cbind(pik,matrix(rgamma(N*p,4,25),ncol= p))

pikstar <- ffphase(X,pik) 
t(X/pik)\%*\%pikstar
t(X/pik)\%*\%pik
pikstar


}
\references{
Chauvet, G. and Tillé, Y. (2006). A fast algorithm of balanced sampling. \emph{Computational Statistics}, 21/1:53-62
}
\seealso{
\code{\link[sampling:samplecube]{fastflightphase}}, \code{\link[BalancedSampling:flightphase]{flightphase}}.
}
\author{
Raphaël Jauslin \email{raphael.jauslin@unine.ch}
}
