% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sec_format.R
\name{sec_format}
\alias{sec_format}
\title{Formatting mm:ss.tt times as seconds}
\usage{
sec_format(x)
}
\arguments{
\item{x}{A character vector of time(s) in swimming format (e.g. 1:35.93) to
be converted to seconds (95.93)}
}
\value{
returns the value of the string \code{x} which represents a time in
  swimming format (mm:ss.hh) and converts it to seconds
}
\description{
Takes a character string (or list) representing time in swimming format (e.g.
1:35.37) and converts it to a numeric value (95.37) or a list of values
representing seconds.
}
\examples{
sec_format("1:35.93")
sec_format("16:45.19")
sec_format("25.43")
sec_format(c("1:35.93", "16:45.19", "25.43"))
sec_format(c("1:35.93", "16:45.19", NA, "25.43", ":55.23"))

}
\seealso{
\code{sec_format} is the reverse of \code{\link{mmss_format}}
}
