% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_plot_homology.R
\name{plot.homology}
\alias{plot.homology}
\title{Plot Persistent Homology via Barcode or Diagram}
\usage{
\method{plot}{homology}(x, ...)
}
\arguments{
\item{x}{a \code{homology} object.}

\item{...}{extra parameters including\describe{
\item{method}{type of visualization; either \code{"barcode"} or \code{"diagram"}.}
}}
}
\value{
a \pkg{ggplot2} object.
}
\description{
Given a persistent homology of the data represented by a reconstructed 
complex in S3 class \code{homology} object, visualize it as either a barcode 
or a persistence diagram using \pkg{ggplot2}.
}
\examples{
\donttest{
# Use 'iris' data
XX = as.matrix(iris[,1:4])

# Compute VR Diagram 
homology = diagRips(XX)

# Plot with 'barcode'
opar <- par(no.readonly=TRUE)
plot(homology, method="barcode")
par(opar)
}

}
\concept{utility}
