% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Check.exp.tilt.R
\name{Check.exp.tilt}
\alias{Check.exp.tilt}
\title{Check exponential tilt model assumption}
\usage{
Check.exp.tilt(Z, S)
}
\arguments{
\item{Z}{True disease status (No disease / treatment success coded as Z=0, diseased / treatment failure coded as Z=1).}

\item{S}{Risk score.}
}
\value{
Plot of empirical density for risk score S, joint empirical density for (S,Z=1) and (S,Z=0), and the density under the exponential tilt model assumption for (S,Z=1) and (S,Z=0).
}
\description{
This function provides graphical assessment to the suitability of the exponential tilt model for risk score in finding optimal tripartite rules by semiparametric approach. 
\deqn{g1(s)=exp(\tilde{\beta}_{0}+\beta_{1}*s)*g0(s)}
}
\examples{
d = Simdata
Z = d$Z # True Disease Status
S = d$S # Risk Score
Check.exp.tilt( Z, S)
}
\keyword{semiparametric}
