% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TGSTFunctions.R
\name{semipar.fnr.fpr}
\alias{semipar.fnr.fpr}
\title{Semiparametric FNR FPR of the rules}
\usage{
semipar.fnr.fpr(Z, S, l, u)
}
\arguments{
\item{Z}{True disease status (No disease / treatment success coded as Z=0, diseased / treatment failure coded as Z=1).}

\item{S}{Risk score.}

\item{l}{Lower cutoff of tripartite rule.}

\item{u}{Upper cutoff of tripartite rule.}
}
\value{
Matrix with 2 columns. Each row is a set of semiparametric (FNR, FPR) on an associated tripartite rule.
}
\description{
This function gives you the semiparametric FNR and FPR associated with a given tripartite rule.
}
\examples{
d = Simdata
Z = d$Z # True Disease Status
S = d$S # Risk Score
phi = 0.1 #10\% of patients taking viral load test
rules = nonpar.rules( Z, S, phi)
semipar.fnr.fpr(Z,S,rules[1,1],rules[1,2])
}
\keyword{rules}
\keyword{semiparametric}
