% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TTformat.r
\name{formatCurrency}
\alias{formatCurrency}
\alias{formatDate}
\alias{formatPercentage}
\alias{formatRound}
\alias{formatSignif}
\alias{formatString}
\alias{formatStyle}
\title{Format table columns}
\usage{
formatCurrency(
  table,
  columns,
  currency = "$",
  interval = 3,
  mark = ",",
  digits = 2,
  dec.mark = getOption("OutDec"),
  before = TRUE
)

formatDate(table, columns, method = "toDateString", params = NULL)

formatPercentage(
  table,
  columns,
  digits = 0,
  interval = 3,
  mark = ",",
  dec.mark = getOption("OutDec")
)

formatRound(
  table,
  columns,
  digits = 2,
  interval = 3,
  mark = ",",
  dec.mark = getOption("OutDec")
)

formatSignif(
  table,
  columns,
  digits = 2,
  interval = 3,
  mark = ",",
  dec.mark = getOption("OutDec")
)

formatString(table, columns, prefix = "", suffix = "")

formatStyle(
  table,
  columns,
  valueColumns = columns,
  target = c("cell", "row"),
  fontWeight = NULL,
  color = NULL,
  backgroundColor = NULL,
  background = NULL,
  ...
)
}
\arguments{
\item{table}{a table object created from \code{\link[DT]{datatable}()}}

\item{columns}{the indices of the columns to be formatted (can be character,
numeric, logical, or a formula of the form \code{~ V1 + V2}, which is
equivalent to \code{c('V1', 'V2')})}

\item{currency}{the currency symbol}

\item{interval}{put a marker after how many digits of the numbers}

\item{mark}{the marker after every \code{interval} decimals in the numbers}

\item{digits}{the number of decimal places to round to}

\item{dec.mark}{a character to indicate the decimal point}

\item{before}{whether to place the currency symbol before or after the values}

\item{method}{the method(s) to convert a date to string in JavaScript; see
\code{DT:::DateMethods} for a list of possible methods, and
\url{https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date}
for a full reference}

\item{params}{a list parameters for the specific date conversion method,
e.g., for the \code{toLocaleDateString()} method, your browser may support
\code{params = list('ko-KR', list(year = 'numeric', month = 'long', day =
'numeric'))}}

\item{prefix}{string to put in front of the column values}

\item{suffix}{string to put after the column values}

\item{valueColumns}{indices of the columns from which the cell values are
obtained; this can be different with the \code{columns} argument, e.g. you
may style one column based on the values of a different column}

\item{target}{the target to apply the CSS styles to (the current cell or the
full row)}

\item{fontWeight}{the font weight, e.g. \code{'bold'} and \code{'normal'}}

\item{color}{the font color, e.g. \code{'red'} and \code{'#ee00aa'}}

\item{backgroundColor}{the background color of table cells}

\item{background}{the background of table cells}

\item{...}{other CSS properties, e.g. \code{'border'}, \code{'font-size'},
\code{'text-align'}, and so on; if you want to condition CSS styles on the
cell values, you may use the helper functions such as
\code{\link[DT]{styleInterval}()}; note the actual CSS property names are
dash-separated, but you can use camelCase names in this function (otherwise
you will have to use backticks to quote the names, e.g. \code{`font-size` =
'12px'}), and this function will automatically convert camelCase names to
dash-separated names (e.g. \code{'fontWeight'} will be converted to
\code{'font-weight'} internally)}
}
\value{
Return formatted 'HTML' widget of 'DataTables'
}
\description{
Simply wrapper on format... family functions of 'DT' package.
For details see: \code{\link[DT]{formatCurrency}}\cr
The wrappers are not affecting behavior of original format... functions
}
