% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TeachHistRelFreq.R
\name{TeachHistRelFreq}
\alias{TeachHistRelFreq}
\title{Build a Histogram for Relative Frequencies with Regular and z-Value Axis}
\usage{
TeachHistRelFreq(
  Mean = 0,
  Sd = 1,
  PlotData = dplyr::tibble(x = c(0)),
  VLine1 = NULL,
  VLine2 = NULL,
  BinWidth = 0.5,
  XAxisMax = 5,
  LabelSize = 3,
  NOfSimData = 1000,
  SeedValue = NULL,
  PrintRelFreq = TRUE
)
}
\arguments{
\item{Mean}{(default=0) Mean for simulated data (ignored if PlotData is set).}

\item{Sd}{(default=1) Standard Deviation for simulated data (ignored if PlotData is set).}

\item{PlotData}{If PlotData is set to a Tibble with one column, the histogram will be based on the provided data.
If PlotData is not set, the data for the histogram will be simulated based on the settings for Mean and Sd.}

\item{VLine1}{(default= NA) A value for the simulated variable resulting in a vertical line at related x-axis position (can be se by user. E.g. lower boundary of conf intervall).}

\item{VLine2}{(default=NA) A value for the simulated variable resulting in a vertical line at related x-axis position (can be se by user. E.g. upper boundary of conf intervall).}

\item{BinWidth}{(default=0.5) Bin width expressed in standard deviations.}

\item{XAxisMax}{(default=5) X-axis ranges from negative to positive XAxisMax. If XAxisMax is not high enough, some of the simulated points might not be considered.}

\item{LabelSize}{(default=3) Size of the labels inside the diagram.}

\item{NOfSimData}{(default=100000) Number of simulated data points. Higher NOfSimData results in better precision but possibly not all points are considered.}

\item{SeedValue}{(default=NULL) Can be any integer and makes simulated points reproduceable.}

\item{PrintRelFreq}{(default=TRUE) Set PrintRelFreq=FALSE to supress the printing of relative frequencies in the histogram.}
}
\value{
Returns a histogram
}
\description{
The TeachHistRelFreq function is a variation of the TeachHistDens function of this package. TeachHistRelFreq generates a
relative frequency histogram with two horizontal axis. One axis displays z-values the other one the
dimension of the displayed variable.
}
\details{
There are two ways to generate the histogram.:
   1) Simulated Data: Provide Mean and Standard Deviation and the histogram will be generated based on simulated data.
   2) Provide Data as a Data Frame (Tibble)
   Provide data (a Tibble with one column) and a histogram will be generated based on the provided data.
Histogram Design:
The Histogram will have two axis. One axis is for the simulated random variable the other is the related  Z-value (deviation from mean in standard deviations).
The user can also define up to two reference lines that will be plotted as vertical lines in the plot (see VLine1 and VLine2).
}
\examples{
TeachHistRelFreq()
TeachHistRelFreq(70,2)
MyTibbleWithOneColumn=dplyr::tibble(x=rnorm(2000,20,2))
TeachHistRelFreq(PlotData=MyTibbleWithOneColumn)
}
