% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jsonparser.R
\name{ParsePreambleForOptions}
\alias{ParsePreambleForOptions}
\title{ParsePreambleForOptions}
\usage{
ParsePreambleForOptions(preamble)
}
\arguments{
\item{preamble}{character vector identifying the preamble from which to pass the JSON readon through}
}
\value{
Returns a list, that concatenates all the lists of options described on the file.
}
\description{
This function parses a preamble of a document trying to read options handed to the package TexExamRandomizer to be used in compiling.
}
\details{
It find all \code{\%!TexExamRandomizer = {}} lines. It then uses the function  \code{\link[jsonlite]{fromJSON}} to parse them, and it concatenates all those options.

If more than one option with the same name is given, it tries to concatenate those.
However, it doesn't do that recursively, only if the names of the outer layer are the same... therefore, in nested structure you might end up with a list that have twice the same name. Keep in mind that in those cases, the default behaviour of R is to select the first one.
}
\seealso{
Other jsoncompiler: \code{\link{jsonexamparser}},
  \code{\link{jsonhwparser}}
}
