% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Trade_Decision.R
\name{Trade_Decision}
\alias{Trade_Decision}
\title{Trade_Decision}
\usage{
Trade_Decision(
  Current_Sentiment_Index,
  Past_Sentiment_Index,
  Use_Delta_Sentiment,
  Sentiment_Index_Threshold,
  past_decision
)
}
\arguments{
\item{Current_Sentiment_Index}{The current sentiment index}

\item{Past_Sentiment_Index}{The sentiment index in (t-1)}

\item{Use_Delta_Sentiment}{If True the fuction will consider the difference in the sentiment index in the decision.}

\item{Sentiment_Index_Threshold}{The threshold to define if the decision will be following or against the sentiment.}

\item{past_decision}{The last trade decision.}
}
\value{
The vector with the decision.
}
\description{
This function takes as arguments the sentiment indexes and returns the decision.
}
\examples{

buy_sell_t1 <- 0.2
buy_sell_t <- 0.5
Use_Delta_Sentiment <- TRUE
Sentiment_Index_Threshold <- 0.5

decision <- Trade_Decision(Current_Sentiment_Index = buy_sell_t,
                          Past_Sentiment_Index = buy_sell_t1,
                          Use_Delta_Sentiment =  Use_Delta_Sentiment,
                          Sentiment_Index_Threshold = Sentiment_Index_Threshold,
                          past_decision = decision
)



}
