% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/File_Reading_Functions.R
\name{read_AG_raw}
\alias{read_AG_raw}
\title{File reading function for primary accelerometer files}
\usage{
read_AG_raw(file, output_window_secs = 1, verbose = FALSE)
}
\arguments{
\item{file}{A character scalar giving path to primary accelerometer file}

\item{output_window_secs}{the desired epoch length; defaults to one second}

\item{verbose}{A logical scalar: print progress updates?}
}
\value{
A dataframe giving processed raw data from the primary accelerometer in the specified epoch length
}
\description{
File reading function for primary accelerometer files
}
\examples{
raw_file <-
    system.file("extdata",
    "TestID_LeftWrist_RAW.csv",
    package = "TwoRegression")

read_AG_raw(raw_file)

}
