% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comorbidity_asso.R
\name{comorbidity_asso}
\alias{comorbidity_asso}
\title{Generate comorbidity association result file}
\usage{
comorbidity_asso(
  pheno,
  covariates,
  cormorbidity,
  population = "all",
  cov.name = c("sex", "age", "bmi"),
  phe.name,
  ICD10.file
)
}
\arguments{
\item{pheno}{phenotype dataframe - output from makePheno function}

\item{covariates}{covariate dataframe - output from risk.factor function.  Optional.}

\item{cormorbidity}{Comorbidity summary generated from comorbidity.summary.}

\item{population}{Choose self-report population/ethnic background group from "all", white", "black", "asian", "mixed", or "other". By default, population="all", include all ethnic groups.}

\item{cov.name}{Selected covariates names. By default, cov.name=c("sex","age","bmi"), covariates are sex age and BMI.}

\item{phe.name}{Phenotype name.}

\item{ICD10.file}{The ICD10 code file, which is included in the package.}
}
\value{
Outputs a comorbidity association test result with OR, 95\% CI and p-value.
}
\description{
Association tests between each co-morbidity and given phenotype (susceptibility, mortality or severity) with the adjustment of covariates.
}
\examples{
\dontrun{
comorb.asso <- comorbidity_asso(pheno=phe,
covariates=covar,
cormorbidity=comorb,
population="white",
cov.name=c("sex","age","bmi","SES","smoke","inAgedCare"),
phe.name="hospitalisation",
ICD10.file=covid_example("ICD10.coding19.txt.gz"))
}

}
