% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comorbidity_summary.R
\name{comorbidity_summary}
\alias{comorbidity_summary}
\title{Create comorbidity summary file}
\usage{
comorbidity_summary(
  ukb.data,
  hesin.file,
  hesin_diag.file,
  primary = FALSE,
  ICD10.file,
  Date.start = NULL,
  Date.end = NULL
)
}
\arguments{
\item{ukb.data}{tab delimited UK Biobank phenotype file, containing sample qc fields (with default UKBiobank codes as column names)}

\item{hesin.file}{Latest hospital inpatient master file.}

\item{hesin_diag.file}{Latest hospital inpatient diagnosis file.}

\item{primary}{TRUE: include primary diagnosis only; FALSE: include all diagnoses.}

\item{ICD10.file}{The ICD10 code file, which is included in the package.}

\item{Date.start}{Date, dd/mm/yyyy, select the start date of hospital inpatient record period.}

\item{Date.end}{Date, dd/mm/yyyy, select the end date of hospital inpatient record period.}
}
\value{
Outputs comorbidity summary table, named comorbidity_<Date.start>_<Date.end>.RData, including phenotype, non-genetic risk factors and all comorbidities, which will be used in the comorbidity association tests.
}
\description{
summarise disease history records of each individual from the hospital inpatient diagnosis data.
}
\examples{
\dontrun{
comorb <- comorbidity_summary(ukb.data=covid_example("sim_ukb.tab.gz"),
hesin.file=covid_example("sim_hesin.txt.gz"), 
hesin_diag.file=covid_example("sim_hesin_diag.txt.gz"), 
ICD10.file=covid_example("ICD10.coding19.txt.gz"),
primary = FALSE,
Date.start = "16/03/2020")
}

}
