% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asso_test.R
\name{log_cov}
\alias{log_cov}
\title{Perform association tests between phenotype and covariates}
\usage{
log_cov(pheno, covariates, phe.name, cov.name = c("sex", "age", "bmi"))
}
\arguments{
\item{pheno}{phenotype dataframe - output from makePhenotypes function}

\item{covariates}{covariate dataframe - output from risk_factor function.}

\item{phe.name}{Phenotype name in the data.}

\item{cov.name}{Selected covariate names in the data. By default, cov.name=c("sex","age","bmi"), covariates include sex, age and BMI.}
}
\value{
Outputs association test results with OR, 95\% CI, and p-value.
}
\description{
Perform association tests between phenotype and covariates
}
\examples{
\dontrun{
log_cov(pheno=phe, covariates=covar, phe.name="hospitalisation", cov.name=c("sex","age","bmi"))
}
}
