% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeGWASFiles.R
\name{makeGWASFiles}
\alias{makeGWASFiles}
\title{Generate files for GWAS Software. SAIGE and Plink currently supported.}
\usage{
makeGWASFiles(
  ukb.data,
  pheno,
  covariates,
  phe.name,
  cov.name = NULL,
  includeSampsFile = NULL,
  software = "SAIGE",
  outDir = "",
  prefix
)
}
\arguments{
\item{ukb.data}{tab delimited UK Biobank phenotype file, containing sample qc fields (with default UKBiobank codes as column names)}

\item{pheno}{phenotype dataframe - output from makePhenotype function}

\item{covariates}{covariate dataframe - output from risk.factor function.  Optional.}

\item{phe.name}{phenotypes to be included in outputted data. multiple phenotypes can be specified as a vector. if null, all phenotypes will be outputted.}

\item{cov.name}{covariates to be included in outputted data. Optional. multiple covariates can be specified as a vector. if null, all covariates in file will be outputted}

\item{includeSampsFile}{list of samples to be included GWAS. File with the first column containing sample IDs to be kept. Can contain other columns. output from sampleQC function may be used.  Optional - if null, all samples will be outputted.}

\item{software}{specify "SAIGE" or "plink" - defaults to "SAIGE"}

\item{outDir}{specify directory to output file}

\item{prefix}{prefix for file - optional}
}
\value{
outputs file, suitable for reading by chosen GWAS software
}
\description{
Generate files for GWAS Software. SAIGE and Plink currently supported.
}
\examples{
\dontrun{
makeGWASFiles(ukb.data=covid_example("sim_ukb.tab.gz"), 
pheno=phe, 
covariates=covar, 
phe.name="hospitalisation", 
cov.name=NULL, 
includeSampsFile=NULL, 
software="SAIGE", 
outDir=covid_example("results"), 
prefix="hospitalisation")
}

}
