% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makePhenotypes.R
\name{makePhenotypes}
\alias{makePhenotypes}
\title{Generate COVID-19 phenotypes}
\usage{
makePhenotypes(
  ukb.data,
  res.eng,
  res.wal = NULL,
  res.sco = NULL,
  death.file,
  death.cause.file,
  hesin.file,
  hesin_diag.file,
  hesin_oper.file,
  hesin_critical.file,
  code.file,
  pheno.type = "severity",
  Date = NULL
)
}
\arguments{
\item{ukb.data}{tab delimited UK Biobank phenotype file.}

\item{res.eng}{Latest covid result file/files for England.}

\item{res.wal}{Latest covid result file/files for Wales. Only available for downloads after April 2021.}

\item{res.sco}{Latest covid result file/files for Scotland. Only available for downloads after April 2021.}

\item{death.file}{Latest death register file.}

\item{death.cause.file}{Latest death cause file.}

\item{hesin.file}{Latest hospital inpatient master file.}

\item{hesin_diag.file}{Latest hospital inpatient diagnosis file.}

\item{hesin_oper.file}{Latest hospital inpatient operation file.}

\item{hesin_critical.file}{Latest hospital inpatient critical care file.}

\item{code.file}{The operation code file, which is included in the package.}

\item{pheno.type}{The phenotype options, which include "susceptibility", "severity", and "mortality".}

\item{Date}{Date, ddmmyyyy, select the results until a certain date. By default, Date = NULL, the latest hospitalization date.}
}
\value{
Returns a data.frame with phenotypes for COVID-19 susceptibility, severity and mortality.
}
\description{
Generate COVID-19 phenotypes
}
\examples{
\dontrun{
pheno <- makePhenotypes(ukb.data=covid_example("sim_ukb.tab.gz"),
res.eng=covid_example("sim_result_england.txt.gz"),
death.file=covid_example("sim_death.txt.gz"),
death.cause.file=covid_example("sim_death_cause.txt.gz"),
hesin.file=covid_example("sim_hesin.txt.gz"),
hesin_diag.file=covid_example("sim_hesin_diag.txt.gz"),
hesin_oper.file=covid_example("sim_hesin_oper.txt.gz"),
hesin_critical.file=covid_example("sim_hesin_critical.txt.gz"),
code.file=covid_example("coding240.txt.gz"),
pheno.type = "severity")
}

}
