% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampleQC.R
\name{sampleQC}
\alias{sampleQC}
\title{Sample QC for genetic analyses}
\usage{
sampleQC(ukb.data, withdrawnFile, ancestry = "all", software = "SAIGE", outDir)
}
\arguments{
\item{ukb.data}{tab delimited UK Biobank phenotype file, containing sample qc fields (with default UKBiobank codes as column names)}

\item{withdrawnFile}{csv file with withdrawn IDs from UK Biobank}

\item{ancestry}{specify "WhiteBritish" or "all" - defaults to "all"}

\item{software}{specify "SAIGE" or "plink" - defaults to "SAIGE"}

\item{outDir}{specify directory for sample QC file and inclusion/exclusion lists}
}
\value{
outputs sample QC file, and sample inclusion / exclusion lists for specified software
}
\description{
Sample QC for genetic analyses
}
\examples{
\dontrun{
sampleQC(ukb.data=covid_example("sim_ukb.tab.gz"), 
withdrawnFile=covid_example("sim_withdrawn.csv.gz"), 
ancestry="all", 
software="SAIGE", 
outDir=covid_example("results"))
}

}
