% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variantQC.R
\name{variantQC}
\alias{variantQC}
\title{Variant QC for Genetic Analyses}
\usage{
variantQC(snpQcFile, mfiDir, mafFilt = 0.001, infoFilt = 0.5, outDir)
}
\arguments{
\item{snpQcFile}{file containing SNP QC info (ukb_snp_qc.txt)}

\item{mfiDir}{directory where the per chromosome UKBiobank MAF/INFO files (ukb_mfi_chr*_v3.txt) are located}

\item{mafFilt}{minor allele frequency filter - default 0.001}

\item{infoFilt}{imputation quality (INFO) score filter - default 0.5}

\item{outDir}{output directory}
}
\value{
outputs SNP inclusion lists (SNPID and rsID formats) for given MAF/INFO filters. Also outputs list of SNPs to be used for genetic Relatedness Matrix (GRM) calculations.
}
\description{
Variant QC for Genetic Analyses
}
\examples{
\dontrun{
variantQC(snpQcFile=covid_example("sim_ukb_snp_qc.txt.gz"), 
mfiDir=covid_example("alleleFreqs"), 
mafFilt=0.001, 
infoFilt=0.5, 
outDir=covid_example("results"))
}

}
