% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bcoef_sh.R
\name{Bcoef_sh}
\alias{Bcoef_sh}
\title{Coefficient matrix}
\usage{
Bcoef_sh(x)
}
\arguments{
\item{x}{An object of class "varshrinkest" generated by VARshrink().}
}
\value{
A matrix holding the estimated coefficients of a VAR.
}
\description{
Returns the estimated coefficients of a VAR(p) model as a matrix.
This is a modification of vars::Bcoef() for the class "varshrinkest".
}
\details{
Consider VAR(p) model:
\deqn{y_t = A_1 y_{t-1} + ... + A_p y_{t-p} + C d_t + e_t .}
The function returns the concatenated matrix (A_1, ..., A_p, C) as a matrix
object.
}
\examples{
data(Canada, package = "vars")
y <- diff(Canada)
estim <- VARshrink(y, p = 2, type = "const", method = "ridge")
Bcoef_sh(estim)
}
\seealso{
\code{\link[vars]{Bcoef}}
}
