% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/advbtvisit.R
\name{advbtsub}
\alias{advbtsub}
\title{Using double list to generate sub tree from vector binary tree}
\usage{
advbtsub(x, inq)
}
\arguments{
\item{x}{The vector binary tree to be visited. Traversal is acheivable through invalid assignment in desired
layers.}

\item{inq}{An integer double list to determine the visiting location. The length of \code{inq} should be the same
as the layers of visited vector binary tree. If any assign element in specificed layer exceeds its intrinsic
length of visited vector binary tree layer, all elements will be returned in this layer.}
}
\value{
Return a sub tree from visited vector binary tree, according to the argument \code{inq}.
}
\description{
Advanced visiting for the vector binary tree. Generating a sub tree from visited vector binary tree,
through specific assigment determined by the argument \code{inq}.
}
\examples{
#Make vector binary tree:
colnamevbt <- dl2vbt(chrvec2dl(colnames(datatest)))

#Visit by specific assignment:
visit <- list(c(2), c(3:6), c(2,4), 1)
advbtsub(colnamevbt, visit)

#Traversal of the second layers:
visit <- list(c(2), colnamevbt$dims[2]+1, c(2,4), 1)
advbtsub(colnamevbt, visit)

#Invalid assignments in 1st and 3rd layers:
visit <- list(c(3), c(3:6), c(5), 1)
advbtsub(colnamevbt, visit)
}
\seealso{
\code{\link[VBTree:vbtinq]{vbtinq}}, \code{\link[VBTree:vbtsub]{vbtsub}}, \code{\link[VBTree:advbtinq]{advbtinq}}.
}
\keyword{Vector.Binary.Tree}
