% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic.R
\name{plot.LRfit}
\alias{plot.LRfit}
\title{Plot the estimated survival-completed cumulative loss curve}
\usage{
\method{plot}{LRfit}(
  x,
  group = NULL,
  conf = FALSE,
  main = NULL,
  xlim = NULL,
  ylim = NULL,
  xlab = "Follow-up time",
  ylab = "Survival-completed cumulative loss",
  group.col = NULL,
  conf.lty = 3,
  lwd = 2,
  legend = TRUE,
  ...
)
}
\arguments{
\item{x}{An object returned by \code{\link{LRfit}}.}

\item{group}{Specifies the group to be plotted.}

\item{conf}{If TRUE, 95\% confidence limits for the target curve are overlaid.}

\item{main}{A main title for the plot.}

\item{xlim}{The x limits of the plot.}

\item{ylim}{The y limits of the plot.}

\item{xlab}{A label for the x axis, defaults to a description of x.}

\item{ylab}{A label for the y axis, defaults to a description of y.}

\item{group.col}{A vector of colors for the group-specific curves; must be commensurate
with the number of groups.}

\item{conf.lty}{Line type for the confidence limits if \code{conf=TRUE}.}

\item{lwd}{Line width.}

\item{legend}{If TRUE, a crude legend for the group-specific curves will appear
on the bottom right corner of the graph.}

\item{...}{Other arguments that can be passed to the underlying \code{plot} method.}
}
\value{
No return value, called for side effects.
}
\description{
Plot the estimated survival-completed cumulative loss (while-alive
loss rate times the length of follow-up) as a function of
the time horizon.
}
\examples{
# load the HF-ACTION trial data
head(hfaction_cpx12)
# fit the data
dat<-hfaction_cpx12
obj<-LRfit(dat$id,dat$time,dat$status,dat$trt)
# print the event numbers by group
obj
# summarize the inference results for tau=3.5 years
# with joint test with RMST
summary(obj,tau=3.5,joint.test=TRUE)
# plot the estimated survival-completed cumulative loss
# by group, with 95\% confidence intervals
plot(obj,conf=TRUE,xlab="Time (years)",xlim=c(0, 3.5),ylim=c(0,3),
    ylab="Survival-completed cumulative frequency")
}
\seealso{
\code{\link{LRfit}}, \code{\link{summary.LRfit}}.
}
\keyword{LRfit}
