% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backLinks.R
\name{backLinks}
\alias{backLinks}
\title{lists pages that link to the Wikipedia page}
\usage{
backLinks(page = NULL, domain = "en")
}
\arguments{
\item{page}{numeric identifier or character title of the specific wikipedia page}

\item{domain}{a character value specifying the language of the wikipedia page.The default value is "en" for "english language".}
}
\value{
an object of class \code{backLinksClass} containing:
\itemize{
\item{\code{call}}{ the command line}
\item{\code{page} }{ title, identification number and domain of the Wikipedia page, created only if the page exists.}
\item{\code{backLinks}}{ a data frame containing 
 \code{title}, the titles of the pages that link to the specific page, 
 \code{pageid}, the pages IDs,
 \code{ns}, numbers of the namespaces (identification of the type of pages, defining nscat et nssubj, the two next variables),  
 \code{nscat}, the categories of linked pages (Subject, Talk, or Virtual), 
 \code{nssubj}, the subjects of the linked pages (Main Article, User, Wikipedia, File, MediaWiki, Template, Help, Category, Protal, Book, Draft, Education Program, TimedText, Module, Topic, Special, Media, Other). 
 For more details about namespace, see \url{http://en.wikipedia.org/wiki/Wikipedia:Namespace#Subject_namespaces}
If the page has no back link or does not exist, this item is not created.
 }
\item{\code{testWikiPage}}{ a list of four elements,
   \itemize{
   \item{\code{takeOnlyFirst}}{ a boolean indicating if the class of \code{page} parameter is invalid, 
             for example vector, list, matrix..., and in that case, only the first element is considered.}
   \item{\code{redirPage}}{ title of the redirected page. This item is NULL if the page is not redirected.}
   \item{\code{test}}{ an integer with value: 
     \itemize{
     \item{4}{ for invalid domain,}
     \item{3}{ for an empty parameter page,}
     \item{2}{ when Wikipedia does not have an article with this exact name,}
     \item{1}{ for ambiguous page, direct or redirect,} 
     \item{0}{ for valid an unambiguous page, direct or redirect. }
     }
   }
   \item{\code{warnMessage}}{ is a vector of warning messages.}
   }
 }
}
}
\description{
lists all pages that link to a specific Wikipedia page.
}
\details{
This function uses API query syntax: "list=backlinks". For more details, see \url{https://www.mediawiki.org/wiki/API:Backlinks}
}
\examples{
\dontrun{
#' # a simple example
backLinks("Louis Pasteur") 

backLinks.Baschet <- backLinks(page ="Cristal Baschet", domain ="fr")
table(backLinks.Baschet$backLinks$nscat)

## example with no back link
backLinks(page = 976, domain = "en" )

# with a page that not exist (at the moment of the redaction of this help page)
backLinks("zzzzz")
}
}
\author{
Avner Bar-Hen, Louise Baschet, Francois-Xavier Jollois, Jeremie Riou
}
\seealso{
print.backLinksClass links
}

