% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/daily_soil_temp_mean.R
\name{daily.soil.temp.mean}
\alias{daily.soil.temp.mean}
\title{Return daily soil temperature means by horizon}
\usage{
daily.soil.temp.mean(site, bgn.date, end.date)
}
\arguments{
\item{site}{Parameter of class character.
The NEON site data should be downloaded for.}

\item{bgn.date}{Optional. The start date of the period to generate statistics for.
If not supplied, the first date of NEON data will be used.}

\item{end.date}{Optional. The end date of the period to generate statistics for.
If not supplied, the last date of NEON data will be used.}
}
\value{
A mean daily soil temperatures, by soil horizon, in degrees centigrade.
}
\description{
This function calculates the daily miniumum, mean, and maximum
temperature values for a site over its period of record for soil sensors located
in plot 1 of the site, at the lowest available instrument in each soil horizon.
}
\examples{
\dontrun{
cper=Z10::daily.soil.temp.mean(site = "CPER")
}
}
\seealso{
Currently none
}
\author{
Robert Lee \email{rhlee@colorado.edu}\cr
}
