% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/acme_post.R
\name{acme.post}
\alias{acme.post}
\title{Posterior Calculation of Mortality}
\usage{
acme.post(C = 0, Rstar = 0.2496, T = 0.174, gam = c(0.5, 0.9), I = 7,
  xlim, Mmax = 200, xi = 1/2, lam = 0, ps = "", plotit = TRUE)
}
\arguments{
\item{C}{Observed mortality count. Non-negative integer.}

\item{Rstar}{ACME inverse-inflation factor R*, reported by acme.summary()
as "Rstar."}

\item{T}{The first term in recursive calculation of Rstar, from acme.summary.}

\item{gam}{Values for highest posterior density credible interval.}

\item{I}{Interval length, days.}

\item{xlim}{2-element vector of plotting ranges. Default first element of 0,
second element of 2 greater than maximum calculated for larger hpd.}

\item{Mmax}{Maximimum value for which posterior probability is calculated.}

\item{xi}{First parameter of gamma prior. Default is 1/2 for Objective prior.}

\item{lam}{Second parameter of gamma prior. Default is 0 for Objective prior.}

\item{ps}{Postscript message. Default empty string suppresses output.}

\item{plotit}{Boolean to determine if plot should be created. Default is TRUE.}
}
\value{
The function invisibly returns a vector with input C, ACME estimate, posterior
mean, and credible interval ranges. If plotit = TRUE, it also plots the posterior
probabilities for values in the range of xlim, and prints a short summery including
the true coverage probabilities.

The parameter \code{plotit} should almost never be set to FALSE - if the user
desires the vector that is inivisibly returned, it is suggested to use the
wrapper function \code{acme.table}.
}
\description{
Calculates and plots the posterior distribution of mortality count.
}
\details{
Assuming a Gamma(xi, lam) on the average daily mortality rate m, this model
treats the mortality M for the current period as Poisson-distributed with
mean m*I. The carcass count C will include "new" carcasses with a Bi(M,T)
distribution as well as "old" carcasses (if bt > 0). For derivation of
resulting conditional pdf see Wolpert (2015).
}
\examples{
acme.post(C=5, Rstar = .25, T = .2, gam = c(.9,.95), I = 5, xi = .5,lam = 0)
}

