% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_results_export.R
\name{search_results_export}
\alias{search_results_export}
\title{Exports search results}
\usage{
search_results_export(
  s,
  path,
  sheetNameXLSX = "data",
  saveAsCSV = FALSE,
  encodingCSV = "UTF-8",
  separatorCSV = ",",
  overwrite = TRUE
)
}
\arguments{
\item{s}{Search object. Search object containing the results you wish to export.}

\item{path}{Character string; path where file will be saved. Please add the suffix '.csv' or '.xlsx' to the file name.}

\item{sheetNameXLSX}{Character string, set the name of the excel sheet.}

\item{saveAsCSV}{Logical; if \code{TRUE} results will be saved as CSV file; Logical; if \code{FALSE} a XLS file will be saved.}

\item{encodingCSV}{Character string; text encoding for CSV files.}

\item{separatorCSV}{Character; single character that is used to separate the columns.}

\item{overwrite}{Logical; if \code{TRUE} existing files will be overwritten}
}
\description{
Search results from a search object will be saved to a Excel-XLSX or a CSV (comma separated values) file.
By default a XLSX file will be saved. If you want to save a CSV file, use \code{saveAsCSV=TRUE}.
Please note: 
- The function will '=' signs at the beginning of annotation by ".=". This is because the content would be interpreted as the beginning of a formula (leading to an error).
- In the case of writing to an excel file, line breaks will be replaced by "|". This is because line breaks will lead to an error.
}
\examples{
library(act)

# Search
mysearch <- act::search_new(examplecorpus, pattern="yo")
nrow(mysearch@results)

# Create temporary file path
path <- tempfile(pattern = "searchresults", tmpdir = tempdir(),
    			 fileext = ".xlsx")

# It makes more sense, however, to you define a destination folder
# that is easier to access on your computer:
\dontrun{
	path <- tempfile(pattern = "searchresults",
 					 tmpdir = "PATH_TO_AN_EXISTING_FOLDER_ON_YOUR_COMPUTER",
 					 fileext = ".xlsx")
}

# Save search results
act::search_results_export(s=mysearch, path=path)

# Do your coding of the search results somewhere outside of act
# ...

# Load search results
mysearch.import <- act::search_results_import(path=path)
nrow(mysearch.import@results)
}
