% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ActivityProbabilityFunctions.R
\name{activityHPDmean}
\alias{activityHPDmean}
\title{Activity highest posterior density interval from mean activity curve}
\usage{
activityHPDmean(
  model,
  prob = 0.5,
  scale = "2pi",
  silent = FALSE,
  plot = FALSE,
  col = "cyan4",
  ymax = "NULL"
)
}
\arguments{
\item{model}{Object of class \code{GCMM} with output from \code{\link{GCMM}} function}

\item{prob}{Value to use for probability density mass; default=0.50}

\item{scale}{Scale of the data, either "2pi" for 0,2pi or "pi" for -pi,pi; default="2pi"}

\item{silent}{Logical vector for whether to print output and plot; default=FALSE}

\item{plot}{Logical argument for whether to plot activity curve with HPD; default=FALSE}

\item{col}{Colour for HPD on plot}

\item{ymax}{Value to use as upper limit of y axis on activity curve plot}
}
\value{
Returns object of class \code{GCMMestimate} with list with estimated peak activity times, maximum activity probability density,
HPD interval, HPD duration, and number of activity peaks.
}
\description{
Estimates activity highest posterior density interval (HPD), HPD duration, number of activity peaks,
peak activity times and maximum activity probability density for a given probability density mass from the
GCMM activity curve predicted by the GCMM parameter posterior distribution means
}
