% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uncertaintyfunctions.R
\name{plotGCMMsamples}
\alias{plotGCMMsamples}
\title{Plot GCMM Activity Curve Posterior Samples}
\usage{
plotGCMMsamples(
  model,
  sample = 100,
  scale = "NULL",
  ymax = "NULL",
  plotmean = TRUE,
  RGB = c(200, 200, 200),
  alpha = 0.05,
  axisunits = "radians",
  lines = TRUE,
  cex.axis = 0.8
)
}
\arguments{
\item{model}{Object of class \code{GCMM} with output from \code{\link{GCMM}} function}

\item{sample}{Number of posterior samples to plot; default=100}

\item{scale}{Scale for which to plot the activity curve, either "pi" for -pi, pi or "2pi" for 0, 2pi; default is that which is recommended by the GCMM function}

\item{ymax}{Value to use as upper limit for y-axis}

\item{plotmean}{Logical argument for whether to plot activity curve from posterior distribution mean; default=TRUE}

\item{RGB}{Vector of RBG values for line colour}

\item{alpha}{Value for line transparency, between 0 (completely transparent) to 1 (completely opaque); default=0.05}

\item{axisunits}{Scale to use for the xaxis, either "radians", "time", "solar", "sun", or "non"; default="radians"}

\item{lines}{Whether to include lines on the graph for the x axis labels; default=TRUE}

\item{cex.axis}{Font size for axis labels}
}
\value{
No return value; prints plot of activity curve posterior samples
}
\description{
Plot GCMM activity curve posterior samples for visualizing estimate uncertatinty
}
