% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/REfunctions.R
\name{plotREs}
\alias{plotREs}
\title{Plot GCMM activity curve with random intercepts}
\usage{
plotREs(
  model,
  RE1 = TRUE,
  RE2 = FALSE,
  scale = "NULL",
  ymax = "NULL",
  axisunits = "radians"
)
}
\arguments{
\item{model}{Object of class \code{GCMM} with output from \code{\link{GCMM}} function}

\item{RE1}{Logical vector for whether to plot GCMM activity curve with random intercepts from RE1; default=TRUE}

\item{RE2}{Logical vector for whether to plot GCMM activity curve with random intercepts from RE2; default=FALSE}

\item{scale}{Scale for plotting the activity curve, either "2pi" for 0,2pi or "pi" for -pi,pi; default="2pi"}

\item{ymax}{Value for upper limit of y axis}

\item{axisunits}{Units for x axis, either "radians", "time", "solar", "sun", or "none"; default="radians"}
}
\value{
No return value; prints plot of GCMM activity curve with random intercepts
}
\description{
Plot GCMM activity curve with random intercepts
}
\examples{
\donttest{ FoxGCMMREs<-GCMM(data=redfoxsample$Radians, RE1=redfoxsample$SamplingPeriod, 
       saveREs=TRUE, scale=c("2pi"), family="vonmises", autorun=FALSE,
       adapt=0, sample=300, burnin=300, thin=1)
    plotREs(FoxGCMMREs) }
}
