% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_param_tte.R
\name{censor_source}
\alias{censor_source}
\title{Create a \code{censor_source} Object}
\usage{
censor_source(
  dataset_name,
  filter = NULL,
  date,
  censor = 1,
  set_values_to = NULL
)
}
\arguments{
\item{dataset_name}{The name of the source dataset

The name refers to the dataset provided by the \code{source_datasets} parameter
of \code{derive_param_tte()}.}

\item{filter}{An unquoted condition for selecting the observations from
\code{dataset} which are events or possible censoring time points.}

\item{date}{A variable providing the date of the event or censoring. A date,
a datetime, or a character variable containing ISO 8601 dates can be
specified. An unquoted symbol is expected.}

\item{censor}{Censoring value

CDISC strongly recommends using \code{0} for events and positive integers for
censoring.}

\item{set_values_to}{A named list returned by \code{vars()} defining the variables
to be set for the event or censoring, e.g. \code{vars(EVENTDESC = "DEATH", SRCDOM = "ADSL", SRCVAR = "DTHDT")}. The values must be a symbol, a
character string, a numeric value, or \code{NA}.}
}
\value{
An object of class \code{censor_source}, inheriting from class \code{tte_source}
}
\description{
\code{censor_source} objects are used to define censorings as input for the
\code{derive_param_tte()} function.
}
\examples{
# Last study date known alive censor
censor_source(
  dataset_name = "adsl",
  date = LSTALVDT,
  set_values_to = vars(
    EVNTDESC = "ALIVE",
    SRCDOM = "ADSL",
    SRCVAR = "LSTALVDT"
  )
)
}
\seealso{
\code{\link[=derive_param_tte]{derive_param_tte()}}, \code{\link[=event_source]{event_source()}}
}
\author{
Stefan Bundfuss
}
\keyword{source_specifications}
