% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/duplicates.R
\name{get_duplicates_dataset}
\alias{get_duplicates_dataset}
\title{Get Duplicate Records that Lead to a Prior Error}
\usage{
get_duplicates_dataset()
}
\value{
A \code{data.frame} or \code{NULL}
}
\description{
Get Duplicate Records that Lead to a Prior Error
}
\details{
Many {admiral} function check that the input dataset contains only one record
per \code{by_vars} group and throw an error otherwise. The \code{get_duplicates_dataset()}
function allows one to retrieve the duplicate records that lead to an error.

Note that the function always returns the dataset of duplicates from the last
error that has been thrown in the current R session. Thus, after restarting the
R sessions \code{get_duplicates_dataset()} will return \code{NULL} and after a second error
has been thrown, the dataset of the first error can no longer be accessed (unless
it has been saved in a variable).
}
\examples{
data(adsl)

# Duplicate the first record
adsl <- rbind(adsl[1L, ], adsl)

signal_duplicate_records(adsl, vars(USUBJID), cnd_type = "warning")

get_duplicates_dataset()
}
\author{
Thomas Neitmann
}
\keyword{user_utility}
