% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate_query.R
\name{validate_query}
\alias{validate_query}
\title{validate_query}
\usage{
validate_query(customer_id, query_instance, token)
}
\arguments{
\item{customer_id}{ADH Customer ID e.g. customers/123}

\item{query_instance}{Query instance returned by create_query function}

\item{token}{Access token retrived from function google_auth()}
}
\value{
If successful, the response body contains a validation queryPerformanceInfo object
}
\description{
Performs static validation checks on the provided analysis query. Reference: <https://developers.google.com/ads-data-hub/reference/rest/v1/customers.analysisQueries/validate>
}
\examples{
\dontrun{
library(adsDataHubR)
token <- google_auth(client_id = client_id, client_secret=client_secret)
validate_query(customer_id, query_instance, token)
}
}
