% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validation.R
\name{validation.index}
\alias{validation.index}
\title{Validation Index}
\usage{
validation.index(object)
}
\arguments{
\item{object}{fuzzy clustering object}
}
\value{
validation index object.
}
\description{
Validation index for validating fuzzy clustering result
}
\details{
This function provide several validation indexs that calculated from fuzzy clustering result. Validation index can be used for choose best optimum parameter.

There are PC, MPC, CE, S, Xie Beni, Kwon, and Tang index. PC (Partition Coefficient), MPC (Modified Partition Coefficient), and CE (Classification Entropy) are calculated from membership matrix. S (Separation Index), Xie Beni, Kwon, and Tang use both distance and membership matrix.

The best cluster result can be decided with minimum value of index, except MPC and PC use maximum value.
}
\section{Slots}{

\describe{
\item{\code{XB}}{Xie Beni Index}

\item{\code{PC}}{Partition Coef.}

\item{\code{MPC}}{Modifief Partition Coef.}

\item{\code{Kwon}}{Kwon Index}

\item{\code{Tang}}{Tang Index}

\item{\code{S}}{Separation Index}

\item{\code{CE}}{Classification Entropy}
}}
\examples{
fuzzy.CM(iris[,1:4],K=3,m=2,max.iteration=100,threshold=1e-5,RandomNumber=1234)->cl
validation.index(cl)->valid
#example for Xie Beni index
XB(valid)
}
\author{
Achmad Fauzi Bagus F
}
\references{
Wang, W., & Zhang, Y. (2007). On Fuzzy Cluster Validity Indices. Fuzzy Sets and System, 2095-2117.
}

