% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adw.R
\name{adw}
\alias{adw}
\title{Angular Distance Weighting}
\usage{
adw(
  dd,
  xmin = NULL,
  xmax = NULL,
  ymin = NULL,
  ymax = NULL,
  gridSize = 1,
  cdd = 1e+06,
  m = 4
)
}
\arguments{
\item{dd}{a input dataframe which contains column names of lon, lat, value}

\item{xmin}{the minimum longitude of the rectangular mesh}

\item{xmax}{the maximum longitude of the rectangular mesh}

\item{ymin}{the minimum latitude of the rectangular mesh}

\item{ymax}{the maximum latitude of the rectangular mesh}

\item{gridSize}{the grid resolution}

\item{cdd}{the correlation decay distance, unit: meter}

\item{m}{is used to adjust the weighting function further}
}
\value{
a regular latitude-longitude grid dataframe
}
\description{
The irregularly-spaced data are interpolated onto regular latitude-longitude grids by weighting each station according to its distance and angle from the center of a search radius.
}
\examples{
set.seed(2)
dd <- data.frame(lon = runif(100, min = 110, max = 117),
                 lat = runif(100, min = 31, max = 37),
                 value = runif(100, min = -10, max = 10))
head(dd)
dg <- adw(dd, gridSize = 1, cdd = 1e5)
# dg is the dataframe of grid (mesh)
head(dg)
}
