\name{affluenceIndex-package}
\alias{affluenceIndex-package}
\alias{affluenceIndex}
\docType{package}
\title{Affluence (richness) indices}

\description{
This package allows to compute the affluence indices (average affluence gap, income share of the top p \%, richness headcount ratio,
concave and convex measures of affluence) and to construct the confidence intervals for the affluence indices. The affluence line is defined by the user 
as multiple of the income median. This package also allows to compute the Medeiros's affluence line which is set as a multiple (defined by the user) of 
the income median. Additionally, this package allows also to compute some standard inequality and polarization measures: 
the Gini coefficient, the Palma index, the Wolfson polarization index. All measures may be calculated with weighted data.

}
\author{
Alicja Wolny-Dominiak, Anna Saczewska-Piotrowska \cr
Maintainer: Alicja Wolny-Dominiak
}
\references{
1. Alichi A., Kantenga K., Sole J. (2016) Income polarization in the United States. IMF Working Paper, WP/16/121.\cr
2. Brzezinski M. (2010) Income affluence in Poland. \emph{Social Indicators Research}, 99, pp. 285-299. \cr
\url{https://link.springer.com/article/10.1007/s11205-010-9580-0} \cr

3. Cobham A., Sumner A.(2013). Is it all about the tails? The Palma measure of income inequality. Working Paper No. 343, Center for Global Development. \cr
4. Creedy J. (2015). A note on computing the Gini inequality measure with weighted data. Workin Paper No. 3, Victoria University of Wellington. \cr
5. Lerman R.I., Yitzhaki S. (1989) Improving the accuracy of estimates of Gini coefficients. \emph{Journal of Econometrics}, 42(1), pp. 43-47. \cr
\url{https://www.sciencedirect.com/science/article/abs/pii/0304407689900742} \cr

6. Medeiros M. (2006) The rich and the poor: the construction of an affluence line from the poverty line. \emph{Social Indicators Research}, 78(1), pp. 1-18. \cr
\url{https://link.springer.com/article/10.1007/s11205-005-7156-1} \cr

7. Peichl A., Schaefer T., Scheicher C. (2008) Measuring richness and poverty - A micro data application to Europe and Germany. IZA Discussion Paper No. 3790, Institute for the Study of Labor (IZA). \cr
8. Saczewska-Piotrowska A. (2015) Identification of determinants of income richness using logistic regression model. 
\emph{Zarzadzanie i Finanse. Journal of Management and Finance}, 4, Part 2, pp. 241-259 (in Polish). \cr
9. Wolfson M.C. (1994) When inequalities diverge, \emph{The American Economic Review}, 84, pp. 353-358.
\url{https://www.jstor.org/stable/2117858 } \cr

}
\keyword{package}
