% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_goodness_crm.R
\name{model_goodness_crm}
\alias{model_goodness_crm}
\title{Computes the goodness of IRT model for all algorithms.}
\usage{
model_goodness_crm(mod)
}
\arguments{
\item{mod}{A fitted \code{mirt} model using the function \code{irtmodel} or \code{R} package \code{mirt}.}
}
\value{
A list with the following components:
\item{\code{goodnessAUC}}{The area under the model goodness curve for each algorithm. }
\item{\code{curves}}{The \code{x,y} coodinates for the model goodness curves for each algorithm. }
}
\description{
This function computes the goodness of the IRT model for all algorithms for different goodness tolerances.
}
\examples{
\donttest{
set.seed(1)
x1 <- runif(100)
x2 <- runif(100)
x3 <- runif(100)
X <- cbind.data.frame(x1, x2, x3)
max_item <- rep(1,3)
min_item <- rep(0,3)
mod <- cirtmodel(X, max.item=max_item, min.item=min_item)
out <- model_goodness_crm(mod$model)
out
}
}
