% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core-functions-batch.R
\docType{methods}
\name{generateReport}
\alias{generateReport}
\alias{generateReport,AnalysisPipeline,character-method}
\title{Generate a HTML report from an \code{AnalysisPipeline} object}
\usage{
generateReport(object, path)

\S4method{generateReport}{AnalysisPipeline,character}(object, path = ".")
}
\arguments{
\item{object}{object that contains input, pipeline, registry and output}

\item{path}{path on the file system, where the generated html report should be stored}
}
\value{
Updated \code{AnalysisPipeline} object
}
\description{
Generate a HTML report from an \code{AnalysisPipeline} object
}
\details{
The sequence of operations stored in the \code{AnalysisPipeline} object are run, outputs generated,
      and a HTML report is generated with outputs in the same sequence as the pipeline created by the user
}
\examples{
\dontrun{
pipelineObj <- AnalysisPipeline(input = iris)
pipelineObj \%>>\% univarCatDistPlots(uniCol = "Species", storeOutput = T) -> pipelineObj
pipelineObj \%>>\% generateReport(path = ".")
}
}
\seealso{
Other Package core functions for batch/one-time analyses: \code{\link{AnalysisPipeline-class}},
  \code{\link{checkSchema}},
  \code{\link{initialize,BaseAnalysisPipeline-method}}
}
\concept{Package core functions for batch/one-time analyses}
