% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anomalize_clean.R
\name{clean_anomalies}
\alias{clean_anomalies}
\title{Clean anomalies from anomalized data}
\usage{
clean_anomalies(data)
}
\arguments{
\item{data}{A \code{tibble} or \code{tbl_time} object.}
}
\value{
Returns a \code{tibble} / \code{tbl_time} object with a new column "observed_cleaned".
}
\description{
Clean anomalies from anomalized data
}
\details{
The \code{clean_anomalies()} function is used to replace outliers with the seasonal and trend component.
This is often desirable when forecasting with noisy time series data to improve trend detection.

To clean anomalies, the input data must be detrended with \code{time_decompose()} and anomalized with \code{anomalize()}.
The data can also be recomposed with \code{time_recompose()}.
}
\examples{

library(dplyr)

# Needed to pass CRAN check / This is loaded by default
set_time_scale_template(time_scale_template())

data(tidyverse_cran_downloads)

tidyverse_cran_downloads \%>\%
    time_decompose(count, method = "stl") \%>\%
    anomalize(remainder, method = "iqr") \%>\%
    clean_anomalies()


}
\seealso{
Time Series Anomaly Detection Functions (anomaly detection workflow):
\itemize{
\item \code{\link[=time_decompose]{time_decompose()}}
\item \code{\link[=anomalize]{anomalize()}}
\item \code{\link[=time_recompose]{time_recompose()}}
}
}
