% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{AbundanceMatrix-class}
\alias{AbundanceMatrix-class}
\alias{.AbundanceMatrix}
\title{Archaeological Data}
\description{
A virtual S4 class to represent archaeological data.
}
\section{Slots}{

\describe{
\item{\code{samples}}{A \code{\link{character}} vector.}

\item{\code{groups}}{A \code{\link{character}} vector.}

\item{\code{totals}}{A \code{\link{numeric}} vector giving the absolute row sums.}

\item{\code{dates}}{An \code{\link{integer}} vector specifying the date point estimate of each
row.}

\item{\code{tpq}}{An \code{\link{integer}} vector specifying the TPQ of each row.}

\item{\code{taq}}{An \code{\link{integer}} vector specifying the TAQ of each row.}
}}

\section{Get and set}{

In the code snippets below, \code{x} is an \code{AbundanceMatrix} object.
\describe{
\item{\code{get_samples(x)} and \code{get_samples(x) <- value}}{Get or set
the sample names of \code{x}.}
\item{\code{get_groups(x)} and \code{set_groups(x) <- value}}{Get or set
the groups of \code{x}.}
\item{\code{get_dates(x)} and \code{set_dates(x) <- value}}{Get or set
the dates of \code{x}. \code{value} can be a \code{\link{list}} with components \code{tpq} (TPQ -
\emph{terminus post quem}) and \code{taq} (TAQ - \emph{terminus ante quem}) or a
\code{\link{numeric}} vector (point estimate). The elements of \code{value} are coerced to
\code{\link{integer}} with \code{\link[=as.integer]{as.integer()}} (hence truncated towards zero).}
}
}

\section{Abundance Matrix}{

The \code{CountMatrix}, \code{CompositionMatrix} and \code{IncidenceMatrix} classes have
special slots:
\itemize{
\item \code{samples} for replicated measurements/observation,
\item \code{groups} to group data by site/area,
\item \code{dates} to specify the date point estimate of an assemblage,
\item \code{tqp} and \code{taq} to specify the chronology of an assemblage.
}

When coercing a \code{data.frame} to a \verb{*Matrix} object, an attempt is made to
automatically assign values to these slots by mapping column names (case
insensitive, plural insensitive). This behavior can be disabled by setting
\code{options(arkhe.autodetect = FALSE)} or overrided by explicitly specifying
the columns to be used in \verb{as_*()}.
}

\section{Chronology}{

The way chronological information is handled is somewhat opinionated.
Sub-annual precision is overkill/meaningless in most situations: dates are
assumed to be expressed in years CE and are stored as integers (values are
coerced with \code{as.integer()} and hence truncated towards zero).
}

\author{
N. Frerebeau
}
\keyword{internal}
