% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asciicast.R
\name{write_json}
\alias{write_json}
\title{Write an ascii cast to file}
\usage{
write_json(cast, path)
}
\arguments{
\item{cast}{\code{asciicast} object.}

\item{path}{Path to write to.}
}
\description{
The file uses the asciinema file format, version 2:
\url{https://github.com/asciinema/asciinema/blob/master/doc/asciicast-v2.md}.
}
\examples{
\dontshow{if (asciicast:::is_recording_supported()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
script <- system.file("examples", "hello.R", package = "asciicast")
cast <- record(script)
json <- tempfile(fileext = ".json")
write_json(cast, json)
\dontshow{unlink(json, recursive = TRUE)}
\dontshow{\}) # examplesIf}
}
\seealso{
Other asciicast functions: 
\code{\link{asciicast-package}},
\code{\link{asciicast_start_process}()},
\code{\link{read_cast}()},
\code{\link{record}()}
}
\concept{asciicast functions}
